
`--------------
` Create Sky
`--------------
function SkyCreate()
   global Sky_SunAngle as Vec4Float
   global Sky_SunDirection as Vec4Float
   global Sky_MoonAngle as Vec4Float
   global Sky_MoonDirection as Vec3Float
   global Sky_StarsAngle as Vec4Float
   global Sky_Color as Vec3Float
   global Sky_NightColor as Vec3Float
   global Sky_Density as float
   global Sky_ScatterPhase as float
   global Sky_Absorption as Vec4Float
   global Sky_AbsorptionSun as Vec4Float
   global Sky_ColorTotal as Vec4Float
   global Sky_SunPhase as Vec4Float
   global Sky_Lighting as Vec4Float
   global Sky_SunScale as float
   global Sky_Scattering as float
   global Sky_CloudsMoved as float
   global Sky_CloudsSize as float
   global Sky_CloudsUVSacle as Vec2Float
   global Sky_CloudsNoiseUVSacle as Vec2Float
   global Sky_CloudsUVSpeed as Vec3Float
   global Sky_CloudsNoiseUVSpeed as Vec2Float
   global Sky_CloudsHeight as Vec2Float
   global Sky_CloudsDensity as float
   global Sky_CloudsCoverage as float
   global Sky_CloudsOldPos as Vec3Float
   global dim Sky_Object[3] as integer
   global dim Sky_Effect[3] as integer
   global dim Sky_Image[6] as integer
   global dim Sky_CloudsRND[100] as float
   Sky_SunScale=0.0325
   Sky_Scattering=2
   Sky_Object[1]=FreeUpObject(5000)
   CreateObjectSphere(Sky_Object[1],-190,18,18)
   Sky_Effect[1]=CreateEffect()
   LoadEffectTechnique(Sky_Effect[1],"Lighting","Shaders\Sky\Sky.vs","Shaders\Sky\Sky.ps")
   LoadEffectTechnique(Sky_Effect[1],"Depth","Shaders\Sky\Depth.vs","Shaders\Sky\Depth.ps")
   SetObjectEffect(Sky_Object[1],Sky_Effect[1],0)
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"SunScale",Sky_SunScale,Sky_SunScale-0.002,50,0)
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"SunIntensity",5,0,0,0)
   Sky_Image[1]=FreeUpImage(5000)
   LoadTexture(Sky_Image[1],"Shaders\Resources\clouds.png")
   Sky_Image[2]=FreeUpImage(5000)
   LoadTexture(Sky_Image[2],"Shaders\Resources\moon.png")
   SetImageWrapU(Sky_Image[2],0) : SetImageWrapV(Sky_Image[2],0)
   Sky_Image[3]=FreeUpImage(5000)
   LoadTexture(Sky_Image[3],"Shaders\Resources\stars.png")
   SetImageWrapU(Sky_Image[3],0) : SetImageWrapV(Sky_Image[3],0)
   SetObjectImage(Sky_Object[1],Sky_Image[1],0)
   SetObjectImage(Sky_Object[1],Sky_Image[2],1)
   SetObjectImage(Sky_Object[1],Sky_Image[3],2)
   SetObjectImage(Sky_Object[1],Lighting_Image[2],3)
   SetObjectImage(Sky_Object[1],Lighting_Image[1],4)
   SetObjectCullMode(Sky_Object[1],0)
   SetObjectVisible(Sky_Object[1],0) 
   Sky_Effect[2]=CreateEffect()
   LoadEffectTechnique(Sky_Effect[2],"Clouds","Shaders\Sky\Cloud.vs","Shaders\Sky\Cloud.ps")
   Sky_Image[4]=FreeUpImage(5000)
   LoadTexture(Sky_Image[4],"Shaders\Resources\cloud layers.png")
   Sky_Image[5]=FreeUpImage(5000)
   LoadTexture(Sky_Image[5],"Shaders\Resources\worley layers.png")
   Sky_Object[2]=FreeUpObject(5000)
   LoadObject(Sky_Object[2],"Shaders\Resources\CloudsA.x")
   SetObjectEffect(Sky_Object[2],Sky_Effect[2],0)
   SetObjectImage(Sky_Object[2],Sky_Image[4],0)
   SetObjectImage(Sky_Object[2],Sky_Image[5],1)
   SetObjecttransparency(Sky_Object[2],3) 
   SetObjectBlendModes(Sky_Object[2],1,3) 
   SetObjectVisible(Sky_Object[2],0) 
   SetObjectCullMode(Sky_Object[2],0) 
   SetObjectDepthWrite(Sky_Object[2],0) 
   Sky_Object[3]=FreeUpObject(5000)
   LoadObject(Sky_Object[3],"Shaders\Resources\CloudsB.x")
   SetObjectEffect(Sky_Object[3],Sky_Effect[2],0)
   SetObjectImage(Sky_Object[3],Sky_Image[4],0)
   SetObjectImage(Sky_Object[3],Sky_Image[5],1)
   SetObjecttransparency(Sky_Object[3],3) 
   SetObjectBlendModes(Sky_Object[3],1,3) 
   SetObjectCullMode(Sky_Object[3],0) 
   SetObjectDepthWrite(Sky_Object[3],0) 
   SetObjectVisible(Sky_Object[3],0) 
   for r=1 to 50
      repeat
         Sky_CloudsRND[r]=random(0,25)
      until (Sky_CloudsRND[r]<Sky_CloudsRND[r-1]-5 or Sky_CloudsRND[r]>Sky_CloudsRND[r-1]+5)
   next r
   SkySetPhase(0.3,0.015)
   SkySetColor(100,150,210,100,110,120)
   SkySetCloudsScale(1,1)
   SkySetSunAngle(0,0,0)
   SkySetMoonAngle(20,40,0,25.05)
   SkySetStarsAngle(0,0,0)
   SkySetCloudHeight(10000,0.8)
   SkySetCloudCoverage(10)
   SkySetCloudDensity(35)
   SkySetCloudScale(2200,80,50,4,4)
endfunction

`--------------
` Sky Update
`--------------
function SkyUpdate(iTimer as float)
   SetObjectScale(Sky_Object[1],Lighting_CameraData.y/100,Lighting_CameraData.y/100,Lighting_CameraData.y/100)
   SetObjectPosition(Sky_Object[1],Lighting_CameraPosition.x,Lighting_CameraPosition.y,Lighting_CameraPosition.z)
   SetObjectPosition(Sky_Object[2],Lighting_CameraPosition.x+Lighting_CameraDir.x*100,Lighting_CameraPosition.y+Lighting_CameraDir.y*100,Lighting_CameraPosition.z+Lighting_CameraDir.z*100)
   SetObjectPosition(Sky_Object[3],Lighting_CameraPosition.x+Lighting_CameraDir.x*100,Lighting_CameraPosition.y+Lighting_CameraDir.y*100,Lighting_CameraPosition.z+Lighting_CameraDir.z*100)
   SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"CloudPosition",Lighting_CameraPosition.x,Lighting_CameraPosition.y,Lighting_CameraPosition.z,0)
   Vector4Float[1].x=(Lighting_CameraPosition.x-Sky_CloudsOldPos.x)*Lighting_CameraDir.x
   Vector4Float[1].y=(Lighting_CameraPosition.y-Sky_CloudsOldPos.y)*Lighting_CameraDir.y
   Vector4Float[1].z=(Lighting_CameraPosition.z-Sky_CloudsOldPos.z)*Lighting_CameraDir.z
   Sky_CloudsMoved=Sky_CloudsMoved-(Vector4Float[1].x+Vector4Float[1].y+Vector4Float[1].z)
   Sky_CloudsOldPos.x=Lighting_CameraPosition.x
   Sky_CloudsOldPos.y=Lighting_CameraPosition.y
   Sky_CloudsOldPos.z=Lighting_CameraPosition.z
   if Sky_CloudsMoved<0 
      Sky_CloudsMoved=Sky_CloudsSize:inc Sky_CloudsRND[0]
   endif
   if Sky_CloudsMoved>Sky_CloudsSize 
      Sky_CloudsMoved=0:dec Sky_CloudsRND[0]
   endif
   if Sky_CloudsRND[0]<0 then Sky_CloudsRND[0]=49
   if Sky_CloudsRND[0]>49 then Sky_CloudsRND[0]=0
   for s=1 to 50
      tRandom=s+Sky_CloudsRND[0]
      if tRandom>50 then tRandom=tRandom-50
      SetShaderConstantArrayVec2ByName(Effects[Sky_Effect[2]].Shader[0],"CloudScale",s,((s-1)+(Sky_CloudsMoved/Sky_CloudsSize))*(Sky_CloudsSize/100)*2,Sky_CloudsRND[tRandom]/25)
   next s
   Sky_CloudsUVSpeed.x=Sky_CloudsUVSpeed.x+0.0001*iTimer
   Sky_CloudsUVSpeed.y=Sky_CloudsUVSpeed.y-0.0001*iTimer
   Sky_CloudsUVSpeed.z=Sky_CloudsUVSpeed.z+0.0005*iTimer
   if Sky_CloudsUVSpeed.x>Sky_CloudsSize then Sky_CloudsUVSpeed.x=0
   if Sky_CloudsUVSpeed.z>Sky_CloudsSize then Sky_CloudsUVSpeed.z=0
   if Sky_CloudsUVSpeed.y>Sky_CloudsSize then Sky_CloudsUVSpeed.y=0
   if Sky_CloudsUVSpeed.x<0 then Sky_CloudsUVSpeed.x=Sky_CloudsSize
   if Sky_CloudsUVSpeed.y<0 then Sky_CloudsUVSpeed.y=Sky_CloudsSize
   if Sky_CloudsUVSpeed.z<0 then Sky_CloudsUVSpeed.z=Sky_CloudsSize
   SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"CloudUv",Sky_CloudsUVSpeed.x*Sky_CloudsSize,Sky_CloudsUVSpeed.y*Sky_CloudsSize,Sky_CloudsUVSpeed.z*Sky_CloudsSize,0)
   Sky_SunDirection.w=Sky_SunDirection.y*3
   if Sky_SunDirection.w>1 then Sky_SunDirection.w=1
   Sky_SunDirection.w=Sky_SunDirection.w*abs(Sky_SunDirection.w)
   Sky_AbsorptionSun.w=-(Sky_SunDirection.w)+Sky_ScatterPhase
   if Sky_AbsorptionSun.w<0.002 then Sky_AbsorptionSun.w=0.002
   tAbsorptionSun#=Sky_AbsorptionSun.w+0.04
   if tAbsorptionSun#>1 then tAbsorptionSun#=1
   Sky_AbsorptionSun.x=exp(Sky_Color.x*-(Sky_Density/(Sky_AbsorptionSun.w^0.75))*0.30102999566)^2
   Sky_AbsorptionSun.y=exp(Sky_Color.y*-(Sky_Density/(Sky_AbsorptionSun.w^0.75))*0.30102999566)^2
   Sky_AbsorptionSun.z=exp(Sky_Color.z*-(Sky_Density/(Sky_AbsorptionSun.w^0.75))*0.30102999566)^2
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"AbsorptionSun",Sky_AbsorptionSun.x,Sky_AbsorptionSun.y,Sky_AbsorptionSun.z,Sky_SunPhase.x)
   Sky_SunPhase.x=-Sky_SunDirection.w+(Sky_ScatterPhase*5)
   if Sky_SunPhase.x<0 then Sky_SunPhase.x=0
   if Sky_SunPhase.x>1 then Sky_SunPhase.x=1
   Sky_SunPhase.y=abs((Sky_SunDirection.y-(Sky_ScatterPhase*5))*10)
   if Sky_SunPhase.y>1 then Sky_SunPhase.y=1
   Sky_SunPhase.w=1.75-((Sky_CloudsDensity/100)+(Sky_CloudsCoverage/100))
   if Sky_SunPhase.w<0 then Sky_SunPhase.w=0
   if Sky_SunPhase.w>1 then Sky_SunPhase.w=1
   Sky_ColorTotal.x=Sky_AbsorptionSun.x*0.5+0.16666*(Sky_AbsorptionSun.x+Sky_AbsorptionSun.y+Sky_AbsorptionSun.z)
   Sky_ColorTotal.y=Sky_AbsorptionSun.y*0.5+0.16666*(Sky_AbsorptionSun.x+Sky_AbsorptionSun.y+Sky_AbsorptionSun.z)
   Sky_ColorTotal.z=Sky_AbsorptionSun.z*0.5+0.16666*(Sky_AbsorptionSun.x+Sky_AbsorptionSun.y+Sky_AbsorptionSun.z)
   Sky_ColorTotal.w=(Sky_ColorTotal.x+Sky_ColorTotal.y+Sky_ColorTotal.z)*2
   if Sky_ColorTotal.w>1 then Sky_ColorTotal.w=1
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"SkyTotal",Sky_ColorTotal.x,Sky_ColorTotal.y,Sky_ColorTotal.z,Sky_ColorTotal.w)
   Sky_Lighting.x=Sky_AbsorptionSun.x+(Sky_NightColor.x*(1-Sky_ColorTotal.w))
   Sky_Lighting.y=Sky_AbsorptionSun.y+(Sky_NightColor.y*(1-Sky_ColorTotal.w))
   Sky_Lighting.z=Sky_AbsorptionSun.z+(Sky_NightColor.z*(1-Sky_ColorTotal.w))
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"LightColor2",((Sky_Lighting.x*Sky_SunPhase.y)^2)*2,((Sky_Lighting.y*Sky_SunPhase.y)^2)*2,((Sky_Lighting.z*Sky_SunPhase.y)^2)*2,0)
   Sky_Lighting.x=(Sky_NightColor.x*0.01)+Sky_ColorTotal.w*(Sky_AbsorptionSun.x-(Sky_NightColor.x*0.01))*tAbsorptionSun#
   Sky_Lighting.y=(Sky_NightColor.y*0.01)+Sky_ColorTotal.w*(Sky_AbsorptionSun.y-(Sky_NightColor.y*0.01))*tAbsorptionSun#
   Sky_Lighting.z=(Sky_NightColor.z*0.01)+Sky_ColorTotal.w*(Sky_AbsorptionSun.z-(Sky_NightColor.z*0.01))*tAbsorptionSun#
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"LightColor1",Sky_Lighting.x*Sky_SunPhase.y*0.5,Sky_Lighting.y*Sky_SunPhase.y*0.5,Sky_Lighting.z*Sky_SunPhase.y*0.5,0)
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"CloudColor",Sky_Lighting.x*0.4,Sky_Lighting.y*0.45,Sky_Lighting.z*0.5,0)
   Sky_Lighting.x=(Sky_NightColor.x)+Sky_ColorTotal.w*(Sky_AbsorptionSun.x-(Sky_NightColor.x))
   Sky_Lighting.y=(Sky_NightColor.y)+Sky_ColorTotal.w*(Sky_AbsorptionSun.y-(Sky_NightColor.y))
   Sky_Lighting.z=(Sky_NightColor.z)+Sky_ColorTotal.w*(Sky_AbsorptionSun.z-(Sky_NightColor.z))
   DirectionalLightSetColor(((Sky_Lighting.x*Sky_SunPhase.y*Sky_SunPhase.w)^0.4545)*255,((Sky_Lighting.y*Sky_SunPhase.y*Sky_SunPhase.w)^0.4545)*255,((Sky_Lighting.z*Sky_SunPhase.y*Sky_SunPhase.w)^0.4545)*255)
   AmbientSetColor(((Sky_Lighting.x*0.05)^0.4545)*255,((Sky_Lighting.y*0.05)^0.4545)*255,((Sky_Lighting.z*0.05)^0.4545)*255)
   FogSetColor(((Sky_Lighting.x*Sky_SunPhase.y*Sky_SunPhase.w)^0.4545)*255,((Sky_Lighting.y*Sky_SunPhase.y*Sky_SunPhase.w)^0.4545)*255,((Sky_Lighting.z*Sky_SunPhase.y*Sky_SunPhase.w)^0.4545)*255,Lighting_Fog.w)
   if Sky_SunDirection.y-(Sky_ScatterPhase*5)<0
      SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"LightDir1",Sky_SunDirection.x*0.5,Sky_CloudsSize*Sky_CloudsHeight.y*Sky_SunDirection.y,Sky_SunDirection.z*0.5,0)
      SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"LightDir2",Sky_SunDirection.x,Sky_SunDirection.y,Sky_SunDirection.z,0)
      DirectionalLightSetAngle(Sky_SunAngle.x,Sky_SunAngle.y,Sky_SunAngle.z)
   else
      SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"LightDir1",Sky_MoonDirection.x*0.5,Sky_CloudsSize*Sky_CloudsHeight.y*Sky_MoonDirection.y,Sky_MoonDirection.z*0.5,0)
      SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"LightDir2",Sky_MoonDirection.x,Sky_MoonDirection.y,Sky_MoonDirection.z,0)
      DirectionalLightSetAngle(Sky_MoonAngle.x,Sky_MoonAngle.y,Sky_MoonAngle.z)
   endif
endfunction

`--------------
` Set Sky Phase
`--------------
function SkySetPhase(iDensity as float,iScatterPhase as float)
   Sky_Density=iDensity
   Sky_ScatterPhase=iScatterPhase
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"Density",Sky_Density,0,0,0)
endfunction

`--------------
` Set Sky Color
`--------------
function SkySetColor(iSkyColorR as float,iSkyColorG as float,iSkyColorB as float,iNightColorR as float,iNightColorG as float,iNightColorB as float)
   Sky_Color.x=((iSkyColorR/255)^2.2)*Sky_Scattering
   Sky_Color.y=((iSkyColorG/255)^2.2)*Sky_Scattering
   Sky_Color.z=((iSkyColorB/255)^2.2)*Sky_Scattering
   Sky_NightColor.x=(iNightColorR/255)^2.2
   Sky_NightColor.y=(iNightColorG/255)^2.2
   Sky_NightColor.z=(iNightColorB/255)^2.2
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"SkyColor",Sky_Color.x,Sky_Color.y,Sky_Color.z,0)
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"NightColor",Sky_NightColor.x,Sky_NightColor.y,Sky_NightColor.z,(Sky_NightColor.x+Sky_NightColor.y+Sky_NightColor.z)*0.3333)
endfunction
`--------------
` Set Sky Cloud Scale
`--------------
function SkySetCloudsScale(iUSacle as float,iVSacle as float)
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"CloudScale",iUSacle,iVSacle,0,0)
endfunction

`--------------
` Set Sun Angle
`--------------
function SkySetSunAngle(iAngX as float,iAngY as float,iAngZ as float)
   Sky_SunAngle.x=wrapvalue(iAngX)
   Sky_SunAngle.y=wrapvalue(iAngY)
   Sky_SunAngle.z=wrapvalue(iAngZ)
   RotateX_Matrix4(1,WrapValue(Sky_SunAngle.x)*0.01745329251)
   RotateY_Matrix4(2,WrapValue(Sky_SunAngle.y)*0.01745329251)
   RotateZ_Matrix4(3,WrapValue(Sky_SunAngle.z)*0.01745329251)
   Multiply_Matrix4(4,1,2)
   Multiply_Matrix4(4,4,3)
   Set_Vector3(1,0,0,1)
   Transform_Normals_Vector3(1,1,4)
   Sky_SunDirection.x=Vector3Float[1].x
   Sky_SunDirection.y=Vector3Float[1].y
   Sky_SunDirection.z=Vector3Float[1].z
   SetShaderConstantByName(Effects[Sky_Effect[1]].Shader[0],"SunDirection",-Sky_SunDirection.x,-Sky_SunDirection.y,-Sky_SunDirection.z,0)
endfunction

`--------------
` Set Moon Angle
`--------------
function SkySetMoonAngle(iAngX as float,iAngY as float,iAngZ as float,iSize as float)
   Sky_MoonAngle.x=wrapvalue(iAngX)
   Sky_MoonAngle.y=wrapvalue(iAngY)
   Sky_MoonAngle.z=wrapvalue(iAngZ)
   Sky_MoonAngle.w=iSize
   RotateX_Matrix4(1,WrapValue(Sky_MoonAngle.x)*0.01745329251)
   RotateY_Matrix4(2,WrapValue(Sky_MoonAngle.y)*0.01745329251)
   RotateZ_Matrix4(3,WrapValue(Sky_MoonAngle.z)*0.01745329251)
   Multiply_Matrix4(4,1,2)
   Multiply_Matrix4(4,4,3)
   Set_Vector3(1,0,0,1)
   Transform_Normals_Vector3(1,1,4)
   Sky_MoonDirection.x=Vector3Float[1].x
   Sky_MoonDirection.y=Vector3Float[1].y
   Sky_MoonDirection.z=Vector3Float[1].z
   set_vector3(1,0,0,0)
   set_vector3(2,-Sky_MoonDirection.x,-Sky_MoonDirection.y,-Sky_MoonDirection.z)
   set_vector3(3,0,1,0)
   Build_LookAtLH_Matrix4(1,1,2,3)
   Build_FovLH_Matrix4(2,Sky_MoonAngle.w*0.25,1,1,100)
   Multiply_Matrix4(3,1,2)
   SetEffectConstantMatrix(Sky_Effect[1],"MoonProj",3)
endfunction

`--------------
` Set Stars Angle
`--------------
function SkySetStarsAngle(iAngX as float,iAngY as float,iAngZ as float)
   Sky_StarsAngle.x=iAngX
   Sky_StarsAngle.y=iAngY
   Sky_StarsAngle.z=iAngZ
   RotateX_Matrix4(1,WrapValue(Sky_StarsAngle.x)*0.01745329251)
   RotateY_Matrix4(2,WrapValue(Sky_StarsAngle.y)*0.01745329251)
   RotateZ_Matrix4(3,WrapValue(Sky_StarsAngle.z)*0.01745329251)
   Multiply_Matrix4(4,1,2)
   Multiply_Matrix4(4,4,3)
   SetEffectConstantMatrix3(Sky_Effect[1],"StarsAngle",4)
endfunction

`--------------
` Set Cloud Scale
`--------------
function SkySetCloudScale(iSacle as float,iUSacle as float,iVSacle as float,iNoiseUSacle as float,iNoiseVSacle as float)
   Sky_CloudsSize=iSacle
   Sky_CloudsUVSacle.x=iUSacle
   Sky_CloudsUVSacle.y=iVSacle
   Sky_CloudsNoiseUVSacle.x=iNoiseUSacle
   Sky_CloudsNoiseUVSacle.y=iNoiseVSacle
   SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"CloudUvScale",Sky_CloudsSize*Sky_CloudsUVSacle.x*0.8,Sky_CloudsSize*Sky_CloudsUVSacle.y*0.8,0,0)
   SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"NoiseUvScale",Sky_CloudsSize*Sky_CloudsNoiseUVSacle.x,Sky_CloudsSize*Sky_CloudsNoiseUVSacle.y,0,0)
   SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"CloudFalloff",Sky_CloudsSize*49,Sky_CloudsSize,0,0)
   SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"CloudHeight",Sky_CloudsHeight.x,Sky_CloudsSize*Sky_CloudsHeight.y,0,0)
endfunction

`--------------
` Set Cloud Coverage
`--------------
function SkySetCloudCoverage(iCoverage as float)
   if iCoverage<0 then iCoverage=0
   if iCoverage>100 then iCoverage=100
   Sky_CloudsCoverage=iCoverage
   SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"CloudCoverage",0.25+(Sky_CloudsCoverage/100),(Sky_CloudsCoverage/100)^0.5,0,0)
endfunction

`--------------
` Set Cloud Density
`--------------
function SkySetCloudDensity(iDensity as float)
   if iDensity<0 then iDensity=0
   if iDensity>100 then iDensity=100
   Sky_CloudsDensity=0.25+(iDensity/50)
   SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"WorleyFbm",Sky_CloudsDensity,Sky_CloudsDensity*(1.0/1.5),Sky_CloudsDensity*((1.0/1.5)/3),Sky_CloudsDensity*(((1.0/1.5)/3)/6))
   Sky_CloudsDensity=iDensity
endfunction

`--------------
` Set Cloud Height
`--------------
function SkySetCloudHeight(iHeight as float,iHeightSacle as float)
   Sky_CloudsHeight.x=iHeight
   Sky_CloudsHeight.y=iHeightSacle
   SetShaderConstantByName(Effects[Sky_Effect[2]].Shader[0],"CloudHeight",Sky_CloudsHeight.x,Sky_CloudsSize*Sky_CloudsHeight.y,0,0)
endfunction


